<?php

defined( 'ABSDEATH' ) || die();

define( 'USERNAME', '' );
define( 'PASSWORD', '' );
define( 'DIR_URI', '' );

# SETTINGS
define( 'DATE_FORMAT', 'PERSIAN' );

/**
 * you can define
 * y # example 1401
 * y/m # example 1401/05
 * y/m/d # example 1401/05/26
 */
define( 'FOLDER_STRUCTURE', 'y/m' );
/**
 * you can define
 * # date
 * # artist
 */
define( 'FOLDER_TYPE', 'date' );
define( 'FOLDER_MUSIC_NAME', 'musician' );

function checkUser( $postArray ) {
	if ( ! isset( $postArray['username'], $postArray['password'], $postArray['file-name'], $postArray['file-url'] ) || $postArray['username'] !== md5( USERNAME ) || $postArray['password'] !== md5( PASSWORD ) ) {
		exit( 'user pass error' );
	}
}

function checkFileIsOnline( $url ) {

	$curl = curl_init();
	curl_setopt_array( $curl, array(
			CURLOPT_URL            => $url,
			CURLOPT_HEADER         => true,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_NOBODY         => true,
			CURLOPT_SSL_VERIFYHOST => false,
			CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36'
		)
	);

	$header = explode( "\n", curl_exec( $curl ) );
	curl_close( $curl );

	if ( empty( $header ) || strpos( $header[0], '200' ) === false ) {
		die( 'url-not-exist' );
	}
}

function createFolder( $folder_name ) {

	//The folder path for our file
	$directory = FOLDER_MUSIC_NAME;

	if ( FOLDER_TYPE === 'date' || $folder_name === false ) {

		if ( strpos( FOLDER_STRUCTURE, 'y' ) !== false ) {
			//Year in YYYY format.
			$year = date( "Y" );
			if ( function_exists( 'jdate' ) && DATE_FORMAT === 'PERSIAN' ) {
				$year = jdate( "Y", time() );
			}
			$directory .= "/$year";
		}
		if ( strpos( FOLDER_STRUCTURE, 'm' ) !== false ) {
			//Month in mm format, with leading zeros.
			$month = date( "m" );
			if ( function_exists( 'jdate' ) && DATE_FORMAT === 'PERSIAN' ) {
				$month = jdate( "m", time() );
			}
			$directory .= "/$month";
		}
		if ( strpos( FOLDER_STRUCTURE, 'd' ) !== false ) {
			$day = date( "d" );
			if ( function_exists( 'jdate' ) && DATE_FORMAT === 'PERSIAN' ) {
				$day = jdate( "d", time() );
			}
			$directory .= "/$day";
		}
	} elseif ( FOLDER_TYPE === 'artist' ) {
		$directory .= '/' . $folder_name;
	}


	// add '/ after directory name -> because we use $directory for uploading file & returning url
	$directory .= '/';

	// If the directory doesn't already exist.
	// Create our directory.
	if ( ! is_dir( $directory ) && ! mkdir( $directory, 0755, true ) ) {
		throw new \RuntimeException( sprintf( 'cant-create-folder-%s', $directory ) );
	}

	return $directory;
}

function checkFileExist( $file ) {
	if ( file_exists( $file ) ) {
		die( DIR_URI . $file );
	}
}

function checkFileType( $file_url ) {
	$allowed = array( 'mp3', 'ogg', 'm4a', 'flac' );
	$ext     = pathinfo( $file_url, PATHINFO_EXTENSION );
	if ( ! in_array( $ext, $allowed, true ) ) {
		die( 'file-type-error' );
	}
}

function clearFileName( $name ) {
	return str_replace( array( ' ', '/', '%20', ',', '\\', '?', '!', '#' ), array(
		'-',
		'-',
		'-',
		'-',
		'-',
		'-',
		'-',
		'-'
	), $name );
}

function downloadFile( $url, $save_path, $data_tags ) {

	$ch      = curl_init();
	$timeout = 15;
	curl_setopt( $ch, CURLOPT_URL, $url );
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
	curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, $timeout );
	curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, false );
	curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
	curl_setopt( $ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36' );

	$data = curl_exec( $ch );
	curl_close( $ch );

	file_put_contents( $save_path, $data );
	chmod( $save_path, 0664 );
	writeTags( $save_path, $data_tags );

	$return_data = array(
		'link' => DIR_URI . $save_path,
		'size' => filesize( $save_path )
	);

	echo implode( '[|||]', $return_data );

}

function writeTags( $file_path, $data ) {


	// defaults
	$default_text = $data['default-text'];
	$music_pic    = $data['cover'];


	$mp3_handler = new getID3();
	$mp3_handler->setOption( array( 'encoding' => 'UTF-8' ) );

	$mp3_writer                    = new getid3_writetags();
	$mp3_writer->filename          = $file_path;
	$mp3_writer->tagformats        = array( 'id3v1', 'id3v2.3' );
	$mp3_writer->overwrite_tags    = true;
	$mp3_writer->tag_encoding      = 'UTF-8';
	$mp3_writer->remove_other_tags = true;

	$mp3_data = array();
	foreach ( $data['tags'] as $key => $tag ) {
		$mp3_data[ $key ][] = $tag;
	}

	if ( ! empty( $music_pic ) ) {
		$mp3_data['attached_picture'][0]['data']          = file_get_contents( $music_pic );
		$mp3_data['attached_picture'][0]['picturetypeid'] = 2;
		$mp3_data['attached_picture'][0]['mime']          = 'image/jpeg';
		$mp3_data['attached_picture'][0]['description']   = $default_text;
	}
	$mp3_writer->tag_data = $mp3_data;

	if ( $mp3_writer->WriteTags() ) {
		return true;
	}

	return false;

}
